<?php
/**
 * Settings page template for rtAV VBot plugin
 */

if (!defined('ABSPATH')) {
    exit;
}

$rtav_vbot_settings = RTAV_Settings::get_settings();
?>

<div class="wrap rtav-vbot-settings">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <form method="post" action="options.php">
        <?php settings_fields('rtav_vbot_settings'); ?>
        
        <table class="form-table">
            <tr>
                <th scope="row">
                    Version
                </th>
                <td>
                    <?php echo esc_html(RTAV_VBOT_VERSION); ?>
                </td>
            </tr>
        
            <tr>
                <th scope="row">
                    <label for="rtav_enabled"><?php esc_html_e('Enable VBot', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <input type="checkbox" 
                           id="rtav_enabled" 
                           name="rtav_vbot_settings[enabled]" 
                           value="1" 
                           <?php checked($rtav_vbot_settings['enabled'], 1); ?>>
                    <p class="description">
                        <?php esc_html_e('Enable the video chat bot widget on your site.', 'rtav-vbot'); ?>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="rtav_api_key"><?php esc_html_e('rtAV API Key', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <input type="password" 
                           id="rtav_api_key" 
                           name="rtav_vbot_settings[api_key]" 
                           value="<?php echo esc_attr($rtav_vbot_settings['api_key']); ?>" 
                           class="regular-text">
                    <p class="description">
                        <?php esc_html_e('Get your API key from', 'rtav-vbot'); ?>
                        <a href="https://platform.rtav.io/api-keys" target="_blank">platform.rtav.io</a>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="rtav_color"><?php esc_html_e('Theme Color', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <input type="color" 
                           id="rtav_color" 
                           name="rtav_vbot_settings[color]" 
                           value="<?php echo esc_attr($rtav_vbot_settings['color']); ?>">
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="rtav_position"><?php esc_html_e('Widget Position', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <select id="rtav_position" name="rtav_vbot_settings[position]">
                        <option value="bottom-right" <?php selected($rtav_vbot_settings['position'], 'bottom-right'); ?>>
                            <?php esc_html_e('Bottom Right', 'rtav-vbot'); ?>
                        </option>
                        <option value="bottom-left" <?php selected($rtav_vbot_settings['position'], 'bottom-left'); ?>>
                            <?php esc_html_e('Bottom Left', 'rtav-vbot'); ?>
                        </option>
                        <option value="top-right" <?php selected($rtav_vbot_settings['position'], 'top-right'); ?>>
                            <?php esc_html_e('Top Right', 'rtav-vbot'); ?>
                        </option>
                        <option value="top-left" <?php selected($rtav_vbot_settings['position'], 'top-left'); ?>>
                            <?php esc_html_e('Top Left', 'rtav-vbot'); ?>
                        </option>
                    </select>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="rtav_label"><?php esc_html_e('Widget Label', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <input type="text" 
                           id="rtav_label" 
                           name="rtav_vbot_settings[label]" 
                           value="<?php echo esc_attr($rtav_vbot_settings['label']); ?>" 
                           class="regular-text">
                    <p class="description">
                        <?php esc_html_e('Label text shown above the collapsed widget icon.', 'rtav-vbot'); ?>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="rtav_title"><?php esc_html_e('Widget Title', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <input type="text" 
                           id="rtav_title" 
                           name="rtav_vbot_settings[title]" 
                           value="<?php echo esc_attr($rtav_vbot_settings['title']); ?>" 
                           class="regular-text">
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="rtav_name"><?php esc_html_e('Bot Name', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <input type="text" 
                           id="rtav_name" 
                           name="rtav_vbot_settings[name]" 
                           value="<?php echo esc_attr($rtav_vbot_settings['name']); ?>" 
                           class="regular-text">
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="rtav_model"><?php esc_html_e('AI Model (Optional)', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <input type="text" 
                           id="rtav_model" 
                           name="rtav_vbot_settings[model]" 
                           value="<?php echo esc_attr($rtav_vbot_settings['model'] ?? 'gpt-5.2'); ?>" 
                           class="regular-text">
                    <p class="description">
                        <?php esc_html_e('AI model to use. Default: gpt-5.2', 'rtav-vbot'); ?>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="rtav_instructions"><?php esc_html_e('AI Instructions', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <textarea id="rtav_instructions" 
                              name="rtav_vbot_settings[instructions]" 
                              rows="5" 
                              class="large-text"><?php echo esc_textarea($rtav_vbot_settings['instructions']); ?></textarea>
                    <p class="description">
                        <?php esc_html_e('Define how the AI assistant should behave.', 'rtav-vbot'); ?>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="rtav_use_page_content"><?php esc_html_e('Use Page Content', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <input type="checkbox" 
                           id="rtav_use_page_content" 
                           name="rtav_vbot_settings[use_page_content]" 
                           value="1" 
                           <?php checked($rtav_vbot_settings['use_page_content'] ?? true, 1); ?>>
                    <p class="description">
                        <?php esc_html_e('Enable to automatically extract page content and include it in the AI instructions. This allows VBot to answer questions about the current page.', 'rtav-vbot'); ?>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="rtav_max_words"><?php esc_html_e('Max Words Per Response (Optional)', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <input type="number" 
                           id="rtav_max_words" 
                           name="rtav_vbot_settings[max_words]" 
                           value="<?php echo esc_attr($rtav_vbot_settings['max_words'] ?? 60); ?>" 
                           min="1"
                           step="1"
                           class="small-text">
                    <p class="description">
                        <?php esc_html_e('Maximum words per response (approximately converted to tokens). Leave empty for no limit.', 'rtav-vbot'); ?>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="rtav_face"><?php esc_html_e('Face ID (Optional)', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <input type="text" 
                           id="rtav_face" 
                           name="rtav_vbot_settings[face]" 
                           value="<?php echo esc_attr($rtav_vbot_settings['face'] ?? ''); ?>" 
                           class="regular-text">
                    <p class="description">
                        <?php esc_html_e('Custom face ID for the avatar. Leave empty for default.', 'rtav-vbot'); ?>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="rtav_voice"><?php esc_html_e('Voice ID (Optional)', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <input type="text" 
                           id="rtav_voice" 
                           name="rtav_vbot_settings[voice]" 
                           value="<?php echo esc_attr($rtav_vbot_settings['voice'] ?? ''); ?>" 
                           class="regular-text">
                    <p class="description">
                        <?php esc_html_e('Custom voice ID for the avatar. Leave empty for default.', 'rtav-vbot'); ?>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="rtav_driving"><?php esc_html_e('Driving Style (Optional)', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <input type="text" 
                           id="rtav_driving" 
                           name="rtav_vbot_settings[driving]" 
                           value="<?php echo esc_attr($rtav_vbot_settings['driving'] ?? ''); ?>" 
                           class="regular-text">
                    <p class="description">
                        <?php esc_html_e('Avatar behavior style (e.g., "IdleListeningEncouraging"). Leave empty for default.', 'rtav-vbot'); ?>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="rtav_welcome_message"><?php esc_html_e('Welcome Message', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <textarea id="rtav_welcome_message" 
                              name="rtav_vbot_settings[welcome_message]" 
                              rows="2" 
                              class="large-text"><?php echo esc_textarea($rtav_vbot_settings['welcome_message']); ?></textarea>
                    <p class="description">
                        <?php esc_html_e('Initial message shown to users when they open the chat.', 'rtav-vbot'); ?>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="rtav_idle_timeout"><?php esc_html_e('Idle Timeout (seconds)', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <input type="number" 
                           id="rtav_idle_timeout" 
                           name="rtav_vbot_settings[idle_timeout]" 
                           value="<?php echo esc_attr($rtav_vbot_settings['idle_timeout'] ?? 60); ?>" 
                           min="0"
                           step="1"
                           class="small-text">
                    <p class="description">
                        <?php esc_html_e('Automatically disconnect after idle time in seconds (0 = disabled). Default: 60 seconds.', 'rtav-vbot'); ?>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="rtav_idle_message"><?php esc_html_e('Idle Timeout Message', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <textarea id="rtav_idle_message" 
                              name="rtav_vbot_settings[idle_message]" 
                              rows="2" 
                              class="large-text"><?php echo esc_textarea($rtav_vbot_settings['idle_message'] ?? ''); ?></textarea>
                    <p class="description">
                        <?php esc_html_e('Message shown when connection times out due to inactivity.', 'rtav-vbot'); ?>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="rtav_goodbye_message"><?php esc_html_e('Goodbye Message', 'rtav-vbot'); ?></label>
                </th>
                <td>
                    <textarea id="rtav_goodbye_message" 
                              name="rtav_vbot_settings[goodbye_message]" 
                              rows="2" 
                              class="large-text"><?php echo esc_textarea($rtav_vbot_settings['goodbye_message'] ?? ''); ?></textarea>
                    <p class="description">
                        <?php esc_html_e('Message shown when user closes the chat.', 'rtav-vbot'); ?>
                    </p>
                </td>
            </tr>
        </table>
        
        <?php submit_button(); ?>
    </form>
    
    <div class="rtav-preview-section">
        <h2><?php esc_html_e('Preview', 'rtav-vbot'); ?></h2>
        <p class="description">
            <?php esc_html_e('Save your settings and visit your site to see the widget in action.', 'rtav-vbot'); ?>
        </p>
    </div>
</div>
