<?php
/**
 * Plugin Name: rtAV Video Chat Bot
 * Plugin URI: https://rtav.io/wordpress
 * Description: Add AI-powered video chat bot to your WordPress site. Real-time video avatars for customer support.
 * Version: 1.1.1
 * Requires at least: 5.0
 * Requires PHP: 7.2
 * Author: rtAV
 * Author URI: https://rtav.io
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: rtav-vbot
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

$rtav_vbot_version = file_get_contents(plugin_dir_path(__FILE__) . 'VERSION.txt');
$rtav_vbot_version = trim($rtav_vbot_version ?? '1.0.0');

// Define plugin constants
define('RTAV_VBOT_VERSION', $rtav_vbot_version);
define('RTAV_VBOT_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('RTAV_VBOT_PLUGIN_URL', plugin_dir_url(__FILE__));
define('RTAV_VBOT_PLUGIN_BASENAME', plugin_basename(__FILE__));

// Include required files
require_once RTAV_VBOT_PLUGIN_DIR . 'includes/class-rtav-admin.php';
require_once RTAV_VBOT_PLUGIN_DIR . 'includes/class-rtav-frontend.php';
require_once RTAV_VBOT_PLUGIN_DIR . 'includes/class-rtav-settings.php';
require_once RTAV_VBOT_PLUGIN_DIR . 'includes/class-rtav-api.php';

/**
 * Main plugin class
 */
class RTAV_VBot {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        $this->init_hooks();
    }
    
    private function init_hooks() {
        // Activation/deactivation hooks
        register_activation_hook(__FILE__, array($this, 'activate'));
        register_deactivation_hook(__FILE__, array($this, 'deactivate'));
        
        // Initialize components
        add_action('admin_menu', array('RTAV_Admin', 'add_admin_menu'));
        add_action('admin_init', array('RTAV_Admin', 'register_settings'));
        add_action('admin_enqueue_scripts', array('RTAV_Admin', 'enqueue_admin_assets'));
        add_action('wp', array('RTAV_Frontend', 'init'));
    }
    
    public function activate() {
        // Set default options
        $defaults = array(
            'enabled' => false,
            'api_key' => '',
            'title' => 'Customer Support',
            'name' => 'AI Assistant',
            'instructions' => 'You are a helpful customer support assistant.',
            'color' => '#4CAF50',
            'position' => 'bottom-right',
            'welcome_message' => 'Hello! How can I help you today?',
            'label' => 'Chat with us',
            'face' => '',
            'voice' => '',
            'model' => 'gpt-5.2',
            'driving' => '',
            'idle_timeout' => 60,
            'idle_message' => '',
            'goodbye_message' => '',
            'max_words' => 60,
            'use_page_content' => true,
        );
        
        add_option('rtav_vbot_settings', $defaults);
    }
    
    public function deactivate() {
        // Clean up if needed
    }
}

// Initialize plugin
RTAV_VBot::get_instance();
