<?php
/**
 * Settings management for rtAV VBot plugin
 */

if (!defined('ABSPATH')) {
    exit;
}

class RTAV_Settings {
    
    /**
     * Get plugin settings with defaults
     */
    public static function get_settings() {
        $defaults = array(
            'enabled' => false,
            'api_key' => '',
            'title' => 'Customer Support',
            'name' => 'AI Assistant',
            'instructions' => 'You are a helpful customer support assistant.',
            'color' => '#4CAF50',
            'position' => 'bottom-right',
            'welcome_message' => 'Hello! How can I help you today?',
            'label' => 'Chat with us',
            'face' => '',
            'voice' => '',
            'model' => 'gpt-5.2',
            'driving' => '',
            'idle_timeout' => 60,
            'idle_message' => '',
            'goodbye_message' => '',
            'max_words' => 60,
            'use_page_content' => true,
        );
        
        $settings = get_option('rtav_vbot_settings', array());
        return wp_parse_args($settings, $defaults);
    }
    
    /**
     * Update plugin settings
     */
    public static function update_settings($new_settings) {
        $settings = self::get_settings();
        $updated = wp_parse_args($new_settings, $settings);
        return update_option('rtav_vbot_settings', $updated);
    }
    
    /**
     * Sanitize settings input
     */
    public static function sanitize_settings($input) {
        $sanitized = array();
        
        // Handle checkbox - if not set, it's false
        $sanitized['enabled'] = isset($input['enabled']) && $input['enabled'] == '1';
        
        if (isset($input['api_key'])) {
            $sanitized['api_key'] = sanitize_text_field($input['api_key']);
        }
        
        if (isset($input['title'])) {
            $sanitized['title'] = sanitize_text_field($input['title']);
        }
        
        if (isset($input['name'])) {
            $sanitized['name'] = sanitize_text_field($input['name']);
        }
        
        if (isset($input['instructions'])) {
            $sanitized['instructions'] = sanitize_textarea_field($input['instructions']);
        }
        
        if (isset($input['color'])) {
            $sanitized['color'] = sanitize_hex_color($input['color']);
        }
        
        if (isset($input['position'])) {
            $allowed_positions = array('bottom-right', 'bottom-left', 'top-right', 'top-left');
            $sanitized['position'] = in_array($input['position'], $allowed_positions) 
                ? $input['position'] 
                : 'bottom-right';
        }
        
        if (isset($input['welcome_message'])) {
            $sanitized['welcome_message'] = sanitize_textarea_field($input['welcome_message']);
        }
        
        if (isset($input['label'])) {
            $sanitized['label'] = sanitize_text_field($input['label']);
        }
        
        if (isset($input['face'])) {
            $sanitized['face'] = sanitize_text_field($input['face']);
        }
        
        if (isset($input['voice'])) {
            $sanitized['voice'] = sanitize_text_field($input['voice']);
        }
        
        if (isset($input['model'])) {
            $sanitized['model'] = sanitize_text_field($input['model']);
        }
        
        if (isset($input['driving'])) {
            $sanitized['driving'] = sanitize_text_field($input['driving']);
        }
        
        if (isset($input['idle_timeout'])) {
            $sanitized['idle_timeout'] = absint($input['idle_timeout']);
        }
        
        if (isset($input['idle_message'])) {
            $sanitized['idle_message'] = sanitize_textarea_field($input['idle_message']);
        }
        
        if (isset($input['goodbye_message'])) {
            $sanitized['goodbye_message'] = sanitize_textarea_field($input['goodbye_message']);
        }
        
        if (isset($input['max_words'])) {
            $max_words = absint($input['max_words']);
            $sanitized['max_words'] = $max_words > 0 ? $max_words : null;
        }
        
        // Handle checkbox - if not set, it's false
        $sanitized['use_page_content'] = isset($input['use_page_content']) && $input['use_page_content'] == '1';
        
        return $sanitized;
    }
}
