<?php
/**
 * Admin interface for rtAV VBot plugin
 */

if (!defined('ABSPATH')) {
    exit;
}

class RTAV_Admin {
    
    public static function add_admin_menu() {
        add_options_page(
            __('rtAV Video Chat Bot', 'rtav-vbot'),
            __('rtAV VBot', 'rtav-vbot'),
            'manage_options',
            'rtav-vbot',
            array(__CLASS__, 'render_settings_page')
        );
    }
    
    public static function enqueue_admin_assets($hook) {
        if ('settings_page_rtav-vbot' !== $hook) {
            return;
        }
        
        wp_enqueue_style(
            'rtav-admin-css',
            esc_url(RTAV_VBOT_PLUGIN_URL . 'assets/css/admin.css'),
            array(),
            esc_attr(RTAV_VBOT_VERSION)
        );
        
        wp_enqueue_script(
            'rtav-admin-js',
            esc_url(RTAV_VBOT_PLUGIN_URL . 'assets/js/admin.js'),
            array('jquery'),
            esc_attr(RTAV_VBOT_VERSION),
            true
        );
    }
    
    public static function register_settings() {
        register_setting(
            'rtav_vbot_settings', 
            'rtav_vbot_settings',
            array(
                'type'              => 'array',
                'sanitize_callback' => array('RTAV_Settings', 'sanitize_settings'),
            )
        );
    }
    
    public static function render_settings_page() {
        if (!current_user_can('manage_options')) {
            return;
        }
        
        $settings = get_option('rtav_vbot_settings', array());
        
        include RTAV_VBOT_PLUGIN_DIR . 'templates/settings.php';
    }
}
