/**
 * Admin JavaScript for rtAV VBot plugin
 */

(function($) {
    'use strict';
    
    $(document).ready(function() {
        // Handle color picker change to show preview
        $('#rtav_color').on('change', function() {
            var color = $(this).val();
            // Could add live preview functionality here
            console.log('Color changed to:', color);
        });
        
        // Show/hide API key field toggle (optional enhancement)
        var $apiKeyField = $('#rtav_api_key');
        if ($apiKeyField.length) {
            // Could add show/hide toggle button
        }
        
        // Form validation
        $('form').on('submit', function(e) {
            var enabled = $('#rtav_enabled').is(':checked');
            var apiKey = $('#rtav_api_key').val().trim();
            
            if (enabled && !apiKey) {
                alert('Please enter your rtAV API key to enable the widget.');
                e.preventDefault();
                return false;
            }
        });
        
        // Toggle disabled state of fields based on enabled checkbox
        $('#rtav_enabled').on('change', function() {
            var isEnabled = $(this).is(':checked');
            // Optionally disable/enable other fields
            // $('.rtav-vbot-settings input, .rtav-vbot-settings textarea, .rtav-vbot-settings select')
            //     .not(this)
            //     .prop('disabled', !isEnabled);
        });
    });
    
})(jQuery);
